/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import java.util.NoSuchElementException;

public class SelectItem
implements ADQLObject {
    private ADQLOperand operand;
    private String alias = null;
    private boolean caseSensitive = false;

    public SelectItem(ADQLOperand aDQLOperand) {
        this(aDQLOperand, null);
    }

    public SelectItem(ADQLOperand aDQLOperand, String string) {
        this.operand = aDQLOperand;
        this.setAlias(string);
    }

    public SelectItem(SelectItem selectItem) throws Exception {
        this.operand = selectItem.getOperand() != null ? (ADQLOperand)selectItem.getOperand().getCopy() : null;
        this.alias = selectItem.getAlias();
        this.caseSensitive = selectItem.caseSensitive;
    }

    public final ADQLOperand getOperand() {
        return this.operand;
    }

    public final boolean hasAlias() {
        return this.alias != null;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final void setAlias(String string) {
        this.alias = string;
        this.caseSensitive = false;
        if (this.alias != null) {
            StringBuffer stringBuffer = new StringBuffer(this.alias);
            stringBuffer.trimToSize();
            if (stringBuffer.length() == 0) {
                this.alias = null;
                return;
            }
            if (stringBuffer.length() > 1 && stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(stringBuffer.length() - 1) == '\"') {
                stringBuffer.deleteCharAt(0);
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer.trimToSize();
                if (stringBuffer.length() == 0) {
                    this.alias = null;
                    return;
                }
                this.caseSensitive = true;
            }
            this.alias = stringBuffer.toString();
        }
    }

    public final boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public final void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new SelectItem(this);
    }

    @Override
    public String getName() {
        return this.hasAlias() ? this.alias : this.operand.getName();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean operandGot;
            {
                this.operandGot = SelectItem.this.operand == null;
            }

            @Override
            public ADQLObject next() throws NoSuchElementException {
                if (this.operandGot) {
                    throw new NoSuchElementException();
                }
                this.operandGot = true;
                return SelectItem.this.operand;
            }

            @Override
            public boolean hasNext() {
                return !this.operandGot;
            }

            @Override
            public void replace(ADQLObject aDQLObject) throws UnsupportedOperationException, IllegalStateException {
                if (aDQLObject == null) {
                    this.remove();
                } else {
                    if (!this.operandGot) {
                        throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called !");
                    }
                    if (!(aDQLObject instanceof ADQLOperand)) {
                        throw new IllegalStateException("Impossible to replace an ADQLOperand by a " + aDQLObject.getClass().getName() + " !");
                    }
                    SelectItem.this.operand = (ADQLOperand)aDQLObject;
                }
            }

            @Override
            public void remove() {
                if (!this.operandGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called !");
                }
                throw new UnsupportedOperationException("Impossible to remove the only operand (" + SelectItem.this.operand.toADQL() + ") from a SelectItem (" + SelectItem.this.toADQL() + ") !");
            }
        };
    }

    @Override
    public String toADQL() {
        StringBuffer stringBuffer = new StringBuffer(this.operand.toADQL());
        if (this.hasAlias()) {
            stringBuffer.append(" AS ");
            if (this.isCaseSensitive()) {
                stringBuffer.append('\"').append(this.alias).append('\"');
            } else {
                stringBuffer.append(this.alias);
            }
        }
        return stringBuffer.toString();
    }
}

